<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"categorieProdotti","status"=>205);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="categorieProdotti") {
        $cercaCategorie = $_GET["cerca"];
        $parametriRicerca = ($cerca!="") ? array("tipo"=>"ecommerce","nome"=>filter_input(INPUT_GET, "cerca",FILTER_SANITIZE_ADD_SLASHES)) : array("tipo"=>"ecommerce","categoriaMadre"=>0);
        if(isset($_GET["efficacia"])) {
            $parametriRicerca["efficacia"] = filter_input(INPUT_GET, "efficacia",FILTER_SANITIZE_STRING);
        }
    }
    else {
        $cercaCategorie = "";
        $parametriRicerca = array("categoriaMadre"=>0,"tipo"=>"ecommerce");
    }
    
    $parametri = array("tabella"=>"geec_categorie", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);    
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
    $ricerca->setOrdinamento("ORDER BY posizione ASC");
?>
    <h4 class="mb-4 title">Categorie prodotti</h4>
    <a href="../../creaCategoria.php?tipo=ecommerce" class="btn btn-sm btn-primary" >
	Crea categoria<i class="fas fa-plus ml-2"></i>
    </a>
    <hr> 

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cercaCategorie,$campiAggiuntiviRicerca);
            $ricerca->stampaFormRicerca($cercaCategorie,$campiAggiuntiviRicerca);
        ?>
    </div>
    <div class="table-responsive table-sm" id="elencoCategorie">
        <?php

            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"]);
            }
            else {
                $ris = $ricerca->eseguiRicerca(1);
            }

            $colonne = array("ID","Nome","Numero prodotti","Visualizzazioni totali","SEO","Posizione","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);

            $tabella->setTipo("normale");
            while($categoria = $ris->fetch_assoc()) {
                $dataCreazione = date("d/m/Y",strtotime($categoria["dataCreazione"]));
                $azioni = array("modifica"=>"../../creaCategoria.php?id={$categoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$categoria["id"]},'{$categoria["nome"]}')");

                if($categoria["punteggioSeo"]=="scadente") {                                            
                    $stringaPunteggioSEO = "<span class=\"text-danger\">scadente</span>";
                }
                else if($categoria["punteggioSeo"]=="discreta") {
                    $stringaPunteggioSEO = "<span class=\"text-warning\">discreta</span>";
                }
                else if($categoria["punteggioSeo"]=="buona") {
                    $stringaPunteggioSEO = "<span class=\"text-success\">buona</span>";
                }
                else {
                    $stringaPunteggioSEO = "";
                }

                $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                        <input type=\"number\" id=\"nuovaPosizioneCategoria{$categoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$categoria["posizione"]}\">
                        <div class=\"input-group-append\">
                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$categoria["id"]})\">Salva</button>
                        </div>
                    </div>
                </form>";

                $numeroArticoli = $geecomDb->contaRigheTabella("geecEc_prodotti",array("categoria"=>$categoria["id"]));

                $visualizzazioniTotali   = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$categoria["id"]));
                if(!is_numeric($visualizzazioniTotali)) {
                    $visualizzazioniTotali = 0;
                }

                $tabella->aggiungiNuovaRiga(array($categoria["id"],"<a href=../../creaCategoria.php?id={$categoria["id"]}><b>{$categoria["nome"]}</b></a>",$numeroArticoli[0],$visualizzazioniTotali,$stringaPunteggioSEO,$formPosizione),$azioni);

                // cerco e stampo eventuali sottocategorie
                $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                
                while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                    $dataCreazione = date("d/m/Y",strtotime($sottoCategoria["dataCreazione"]));
                    $azioni = array("modifica"=>"../../creaCategoria.php?id={$sottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoria["id"]},'{$sottoCategoria["nome"]}')");

                    $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecEc_prodotti",array("categoria"=>$sottoCategoria["id"]));

                    $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoria["id"]));
                    if(!is_numeric($visualizzazioniTotali)) {
                        $visualizzazioniTotaliSottoCategoria = 0;
                    }

                    if($sottoCategoria["punteggioSeo"]=="scadente") {                                            
                        $stringaPunteggioSEO = "<span class=\"text-danger\">scadente</span>";
                    }
                    else if($sottoCategoria["punteggioSeo"]=="discreta") {
                        $stringaPunteggioSEO = "<span class=\"text-warning\">discreta</span>";
                    }
                    else if($sottoCategoria["punteggioSeo"]=="buona") {
                        $stringaPunteggioSEO = "<span class=\"text-success\">buona</span>";
                    }
                    else {
                        $stringaPunteggioSEO = "";
                    }

                    $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                        <div class=\"input-group input-group-sm d-flex align-items-center\">
                            <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoria["posizione"]}\">
                            <div class=\"input-group-append\">
                                <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoria["id"]})\">Salva</button>
                            </div>
                        </div>
                    </form>";

                    $tabella->aggiungiNuovaRiga(array($sottoCategoria["id"],"<a href=../../creaCategoria.php?id={$sottoCategoria["id"]}><b> - {$sottoCategoria["nome"]}</b></a>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);

                    // cerco e stampo eventuali sottocategorie della sottocategoria
                    $querySottoCategorie    = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                    $risSottoSottoCategorie = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                    while($sottoCategoriaDellaSottoCategoria = $risSottoSottoCategorie->fetch_assoc()) {
                        $dataCreazione = date("d/m/Y",strtotime($sottoCategoriaDellaSottoCategoria["dataCreazione"]));
                        $azioni = array("modifica"=>"../../creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoriaDellaSottoCategoria["id"]},'{$sottoCategoriaDellaSottoCategoria["nome"]}')");

                        $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecEc_prodotti",array("categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));

                        $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));
                        if(!is_numeric($visualizzazioniTotali)) {
                            $visualizzazioniTotaliSottoCategoria = 0;
                        }

                        if($sottoCategoriaDellaSottoCategoria["punteggioSeo"]=="scadente") {                                            
                            $stringaPunteggioSEO = "<span class=\"text-danger\">scadente</span>";
                        }
                        else if($sottoCategoriaDellaSottoCategoria["punteggioSeo"]=="discreta") {
                            $stringaPunteggioSEO = "<span class=\"text-warning\">discreta</span>";
                        }
                        else if($sottoCategoriaDellaSottoCategoria["punteggioSeo"]=="buona") {
                            $stringaPunteggioSEO = "<span class=\"text-success\">buona</span>";
                        }
                        else {
                            $stringaPunteggioSEO = "";
                        }

                        $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoriaDellaSottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoriaDellaSottoCategoria["posizione"]}\">
                                <div class=\"input-group-append\">
                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoriaDellaSottoCategoria["id"]})\">Salva</button>
                                </div>
                            </div>
                        </form>";

                        $tabella->aggiungiNuovaRiga(array($sottoCategoriaDellaSottoCategoria["id"],"<a href=../../creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}><b> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</b></a>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);
                    }
                }
            }

            $tabella->stampa("rigaCategoria", 0);
            $ricerca->stampaPaginazione(true,"index.php");
        ?>
    </div>